/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.saltwatermobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIAvoid;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowParent;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIMate;
import com.lycanitesmobs.core.entity.ai.EntityAIStayByWater;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAvoid;
import com.lycanitesmobs.core.entity.ai.EntityAITargetParent;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.HashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityIka
extends EntityCreatureAgeable
implements IAnimals,
IGroupAnimal {
    EntityAIWander wanderAI;

    public EntityIka(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 0;
        this.experience = 7;
        this.spawnsOnLand = false;
        this.spawnsInWater = true;
        this.hasAttackSound = false;
        this.babySpawnChance = 0.01;
        this.canGrow = true;
        this.setWidth = 0.9f;
        this.setHeight = 0.9f;
        this.fleeHealthPercent = 1.0f;
        this.isHostileByDefault = false;
        this.setupMob();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this).setSink(true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee(this).setLongMemory(false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt(this).setItemList("Vegetables"));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIStayByWater(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoid(this).setNearSpeed(1.3).setFarSpeed(1.2).setNearDistance(5.0).setFarDistance(20.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMate(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowParent(this).setSpeed(1.0));
        this.wanderAI = new EntityAIWander(this);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.wanderAI);
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetParent(this).setSightCheck(false).setDistance(32.0));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupPredator.class));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 10.0);
        baseAttributes.put("movementSpeed", 0.26);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 32.0);
        baseAttributes.put("attackDamage", 2.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("IkaMeatRaw")), 1.0f).setBurningDrop(new ItemStack(ObjectManager.getItem("IkaMeatCooked"))).setMinAmount(2).setMaxAmount(5));
        this.drops.add(new DropRate(new ItemStack(Items.field_151100_aR, 1, 0), 0.25f).setMinAmount(1).setMaxAmount(2));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70090_H()) {
                this.wanderAI.setPauseRate(20);
            } else {
                this.wanderAI.setPauseRate(0);
            }
        }
    }

    @Override
    public float getAISpeedModifier() {
        float waterSpeed = 1.0f;
        if (this.func_70090_H()) {
            waterSpeed = 2.0f;
        } else if (this.waterContact()) {
            waterSpeed = 1.5f;
        }
        if (this.func_110143_aJ() > this.func_110138_aP() / 2.0f) {
            return waterSpeed * 0.75f;
        }
        return waterSpeed;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState blockState = this.field_70170_p.func_180495_p(pos);
        if (blockState.func_177230_c() == Blocks.field_150355_j) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (blockState.func_177230_c() == Blocks.field_150358_i) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)waterWeight;
        }
        if (this.field_70170_p.func_72896_J() && this.field_70170_p.func_175710_j(pos)) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.waterContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public boolean func_184652_a(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canBeTempted() {
        if (this.func_70086_ai() <= -100) {
            return false;
        }
        return super.canBeTempted();
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (ObjectManager.getPotionEffect("weight") != null && potionEffect.func_188419_a() == ObjectManager.getPotionEffect("weight")) {
            return false;
        }
        if (potionEffect.func_188419_a() == MobEffects.field_76440_q) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean canBreatheAboveWater() {
        return false;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (this.func_110143_aJ() > this.func_110138_aP() / 2.0f) {
            return 0.25f;
        }
        return 1.0f;
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        return new EntityIka(this.field_70170_p);
    }

    @Override
    public boolean isBreedingItem(ItemStack testStack) {
        if (this.func_70086_ai() <= -100) {
            return false;
        }
        return ObjectLists.inItemList("Vegetables", testStack);
    }
}

